*! version 5.0
* 13 August 2018
* NIDS

* THIS IS A RENT EXPENDITURE DO FILE: 14 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Rent Expenditure - Master Rent Expenditure (12 of 14).do"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

version 12.0


*===========================================================================================================================================

*	Quick Guide to Variable Names:
*This program uses the questionaire numbers (variables are renamed in the previous .do file)
*d8,d9,d11,d12 are the main rent responses:
*d8-mortgage payments
*d9-what would be recieved if the owned dwelling was rented
*d11-actual rent paid
*d12- what would be paid if rent was required
*d2 is the number of rooms in the dwelling. d13 is the value of the dwelling
*d1 is the dwelling type, d3_1 is the roof type d3_2 if the wall type

*=============================================================================================================================================

use "$DataOUT\tempdata.dta", clear	

*Household characteristic variables
recode w1_h_dwltyp (-9/-3=.) (1=1 "Dwelling/house or brick structure") (2=2 "Traditional dwelling/hut/structure") (3=3 "Flat or apartment") ///
(4=4 "Town/cluster/semi-detached house") (5=3) (6=6 "Dwelling/house/flat/room in backyard") (7=7 "Informal dwelling/shack in backyard") ///
(8=8 "Informal dwelling/shack not in backyard") (9=9 "Room/flatlet ") (10=11) (11=11 "Other"), gen(hometype)

label variable hometype "Type of house"

gen hometype_d=hometype!=.

replace hometype=0 if hometype==.

recode w1_h_dwlrms (-9/-3=.) (35=.), gen(homerooms) 

label variable homerooms "Number of rooms in the house occupied by the household"

gen homerooms_d=homerooms!=.

replace homerooms=0 if homerooms==.

gen homeroomssq=homerooms^2

recode w1_h_dwlmatroof (-9/-3=.) (1=1 "Bricks or cement") (2=1) (3=3 "Corrugated iron/zinc") (4/8=7 "Other") (9=4 "Tile") (10=7 "Other") ///
(11=5 "Thatching") (12=6 "Asbestos/cement roof sheeting") (13=7), gen(homeroof)

label variable homeroof "Material used in the roof of the house"

gen homeroof_d=homeroof!=.

replace homeroof=0 if homeroof==.

recode w1_h_dwlmatrwll (-9/-3=.) (1=1 "Bricks") (2=2 "Cement block/concrete") (3=3 "Corrugated iron/zinc") (7=4 "Mixture of mud and cement") ///
(10=5 "Mud bricks") (4/6=6 "Other") (8/9=6) (11/13=6), gen(homewalls)

label variable homeroof "Material used in the walls of the house"

gen homewalls_d=homewalls!=.

replace homewalls=0 if homewalls==.

rename	w1_h_phase	phase						//renaming interview paradata variables
rename	 w1_h_intrvsrt	a18

*-----------------------------------------------------------------------------
*Renaming household dwelling type destriptor statistics		
rename	w1_h_dwltyp	d1
cap rename	w1_h_dwltyp_o	d1_o
rename	w1_h_dwlrms	d2
rename	w1_h_dwlmatroof	d3_1
rename	w1_h_dwlmatrwll	d3_2
	
*Renaming household ownership variables	
rename	w1_h_ownd	d4
		
rename	w1_h_ownpid1	d5_1
rename	w1_h_ownpid2	d5_2
rename	w1_h_ownpid3	d5_3

rename	w1_h_ownpaid d6
rename	w1_h_ownowd	d7
rename	w1_h_ownmn	d8
rename	w1_h_ownrnt	d9
rename	w1_h_rnt	d10
rename	w1_h_rntpay	d11
rename	w1_h_rntpot	d12

*Renaming dwelling characteristics variables		
rename	w1_h_mrkv	d13
rename	w1_h_sub	d14
rename	w1_h_sub_v	d15
rename	w1_h_lndgrn	d16
rename	w1_h_lndrst	d17
rename	w1_h_watsrc	d18
cap rename	w1_h_watsrc_o	d18_o
rename	w1_h_watdis	d19
rename	w1_h_toi	d20
cap rename	w1_h_toi_o	d20_o
rename	w1_h_toishr	d21
rename	w1_h_enrgelec	d22
rename	w1_h_enrgck	d23_1
cap rename	w1_h_enrgck_o	d23_1_o
rename	w1_h_enrght	d23_2
cap rename	w1_h_enrght_o	d23_2_o
rename	w1_h_enrglght	d23_3
cap rename	w1_h_enrglght_o	d23_3_o
rename	w1_h_tellnd	d24
rename	w1_h_telcel	d25
rename	w1_h_transtrain	d26_1
rename	w1_h_transbus	d26_2
rename	w1_h_transmini	d26_3
rename	w1_h_refrem	d27

*Renaming living standards variables
rename	w1_h_strlght	d28
rename	w1_h_hngradlt	d29
rename	w1_h_hngrchld	d30
rename	w1_h_expnd	d31
		
rename	w1_h_food	d32_1
rename	w1_h_hou	d32_2
rename	w1_h_clth	d32_3
rename	w1_h_hlth	d32_4
rename	w1_h_sch	d32_5
		
rename	w1_h_nbhlp	d33_1
rename	w1_h_nbtog	d33_2
rename	w1_h_nbagg	d33_3
rename	w1_h_nbthf	d33_4
		
rename	w1_h_empl	d34
rename	w1_h_rent	d35
rename	w1_h_grn	d36
rename	w1_h_prvpen	d37
rename	w1_h_tinc	d38
rename	w1_h_tinc_show	d39
	
*-----------------------------------------------------------------------------------
*Renaming food expenditure variables	
rename	w1_h_fdtot	e1_1
rename	w1_h_fdmm	e1_2_1
rename	w1_h_fdsmp	e1_2_2
rename	w1_h_fdflr	e1_2_3
rename	w1_h_fdrice	e1_2_4
rename	w1_h_fdpas	e1_2_5
rename	w1_h_fdbis	e1_2_6
rename	w1_h_fdrm	e1_2_7
rename	w1_h_fdrmc	e1_2_8
rename	w1_h_fdchi	e1_2_9
rename	w1_h_fdfsh	e1_2_10
rename	w1_h_fdfshc	e1_2_11
rename	w1_h_fdvegd	e1_2_12
rename	w1_h_fdpot	e1_2_13
rename	w1_h_fdvego	e1_2_14
rename	w1_h_fdfru	e1_2_15
rename	w1_h_fdoil	e1_2_16
rename	w1_h_fdmar	e1_2_17
rename	w1_h_fdpb	e1_2_18
rename	w1_h_fdmlk	e1_2_19
rename	w1_h_fdegg	e1_2_20
rename	w1_h_fdsug	e1_2_21
rename	w1_h_fdsd	e1_2_22
rename	w1_h_fdfrut	e1_2_23
rename	w1_h_fdcer	e1_2_24
rename	w1_h_fdbaby	e1_2_25
rename	w1_h_fdslt	e1_2_26
rename	w1_h_fdsoy	e1_2_27
rename	w1_h_fdcof	e1_2_28
rename	w1_h_fdhmp	e1_2_29
rename	w1_h_fdrdy	e1_2_30
rename	w1_h_fdout	e1_2_31
rename	w1_h_fdo	e1_2_32
		
rename	w1_h_fdmmspn	e1_3_1
rename	w1_h_fdsmpspn	e1_3_2
rename	w1_h_fdflrspn	e1_3_3
rename	w1_h_fdricespn	e1_3_4
rename	w1_h_fdpasspn	e1_3_5
rename	w1_h_fdbisspn	e1_3_6
rename	w1_h_fdrmspn	e1_3_7
rename	w1_h_fdrmcspn	e1_3_8
rename	w1_h_fdchispn	e1_3_9
rename	w1_h_fdfshspn	e1_3_10
rename	w1_h_fdfshcspn	e1_3_11
rename	w1_h_fdvegdspn	e1_3_12
rename	w1_h_fdpotspn	e1_3_13
rename	w1_h_fdvegospn	e1_3_14
rename	w1_h_fdfruspn	e1_3_15
rename	w1_h_fdoilspn	e1_3_16
rename	w1_h_fdmarspn	e1_3_17
rename	w1_h_fdpbspn	e1_3_18
rename	w1_h_fdmlkspn	e1_3_19
rename	w1_h_fdeggspn	e1_3_20
rename	w1_h_fdsugspn	e1_3_21
rename	w1_h_fdsdspn	e1_3_22
rename	w1_h_fdfrutspn	e1_3_23
rename	w1_h_fdcerspn	e1_3_24
rename	w1_h_fdbabyspn	e1_3_25
rename	w1_h_fdsltspn	e1_3_26
rename	w1_h_fdsoyspn	e1_3_27
rename	w1_h_fdcofspn	e1_3_28
rename	w1_h_fdhmpspn	e1_3_29
rename	w1_h_fdrdyspn	e1_3_30
rename	w1_h_fdoutspn	e1_3_31
rename	w1_h_fdospn	e1_3_32
		
rename	w1_h_fdmmgft	e1_4_1
rename	w1_h_fdsmpgft	e1_4_2
rename	w1_h_fdflrgft	e1_4_3
rename	w1_h_fdricegft	e1_4_4
rename	w1_h_fdpasgft	e1_4_5
rename	w1_h_fdbisgft	e1_4_6
rename	w1_h_fdrmgft	e1_4_7
rename	w1_h_fdrmcgft	e1_4_8
rename	w1_h_fdchigft	e1_4_9
rename	w1_h_fdfshgft	e1_4_10
rename	w1_h_fdfshcgft	e1_4_11
rename	w1_h_fdvegdgft	e1_4_12
rename	w1_h_fdpotgft	e1_4_13
rename	w1_h_fdvegogft	e1_4_14
rename	w1_h_fdfrugft	e1_4_15
rename	w1_h_fdoilgft	e1_4_16
rename	w1_h_fdmargft	e1_4_17
rename	w1_h_fdpbgft	e1_4_18
rename	w1_h_fdmlkgft	e1_4_19
rename	w1_h_fdegggft	e1_4_20
rename	w1_h_fdsuggft	e1_4_21
rename	w1_h_fdsdgft	e1_4_22
rename	w1_h_fdfrutgft	e1_4_23
rename	w1_h_fdcergft	e1_4_24
rename	w1_h_fdbabygft	e1_4_25
rename	w1_h_fdsltgft	e1_4_26
rename	w1_h_fdsoygft	e1_4_27
rename	w1_h_fdcofgft	e1_4_28
rename	w1_h_fdhmpgft	e1_4_29
rename	w1_h_fdrdygft	e1_4_30
rename	w1_h_fdoutgft	e1_4_31
rename	w1_h_fdogft	e1_4_32
		
rename	w1_h_fdmmpay	e1_5_1
rename	w1_h_fdsmppay	e1_5_2
rename	w1_h_fdflrpay	e1_5_3
rename	w1_h_fdricepay	e1_5_4
rename	w1_h_fdpaspay	e1_5_5
rename	w1_h_fdbispay	e1_5_6
rename	w1_h_fdrmpay	e1_5_7
rename	w1_h_fdrmcpay	e1_5_8
rename	w1_h_fdchipay	e1_5_9
rename	w1_h_fdfshpay	e1_5_10
rename	w1_h_fdfshcpay	e1_5_11
rename	w1_h_fdvegdpay	e1_5_12
rename	w1_h_fdpotpay	e1_5_13
rename	w1_h_fdvegopay	e1_5_14
rename	w1_h_fdfrupay	e1_5_15
rename	w1_h_fdoilpay	e1_5_16
rename	w1_h_fdmarpay	e1_5_17
rename	w1_h_fdpbpay	e1_5_18
rename	w1_h_fdmlkpay	e1_5_19
rename	w1_h_fdeggpay	e1_5_20
rename	w1_h_fdsugpay	e1_5_21
rename	w1_h_fdsdpay	e1_5_22
rename	w1_h_fdfrutpay	e1_5_23
rename	w1_h_fdcerpay	e1_5_24
rename	w1_h_fdbabypay	e1_5_25
rename	w1_h_fdsltpay	e1_5_26
rename	w1_h_fdsoypay	e1_5_27
rename	w1_h_fdcofpay	e1_5_28
rename	w1_h_fdhmppay	e1_5_29
rename	w1_h_fdrdypay	e1_5_30
rename	w1_h_fdoutpay	e1_5_31
rename	w1_h_fdopay	e1_5_32
		
rename	w1_h_fdmmprd	e1_6_1
rename	w1_h_fdsmpprd	e1_6_2
rename	w1_h_fdflrprd	e1_6_3
rename	w1_h_fdriceprd	e1_6_4
rename	w1_h_fdpasprd	e1_6_5
rename	w1_h_fdbisprd	e1_6_6
rename	w1_h_fdrmprd	e1_6_7
rename	w1_h_fdrmcprd	e1_6_8
rename	w1_h_fdchiprd	e1_6_9
rename	w1_h_fdfshprd	e1_6_10
rename	w1_h_fdfshcprd	e1_6_11
rename	w1_h_fdvegdprd	e1_6_12
rename	w1_h_fdpotprd	e1_6_13
rename	w1_h_fdvegoprd	e1_6_14
rename	w1_h_fdfruprd	e1_6_15
rename	w1_h_fdoilprd	e1_6_16
rename	w1_h_fdmarprd	e1_6_17
rename	w1_h_fdpbprd	e1_6_18
rename	w1_h_fdmlkprd	e1_6_19
rename	w1_h_fdeggprd	e1_6_20
rename	w1_h_fdsugprd	e1_6_21
rename	w1_h_fdsdprd	e1_6_22
rename	w1_h_fdfrutprd	e1_6_23
rename	w1_h_fdcerprd	e1_6_24
rename	w1_h_fdbabyprd	e1_6_25
rename	w1_h_fdsltprd	e1_6_26
rename	w1_h_fdsoyprd	e1_6_27
rename	w1_h_fdcofprd	e1_6_28
rename	w1_h_fdhmpprd	e1_6_29
rename	w1_h_fdrdyprd	e1_6_30
rename	w1_h_fdoutprd	e1_6_31
rename	w1_h_fdoprd	e1_6_32

*------------------------------------------------------------------------------------
*Renaming non-food expenditure variables		
rename	w1_h_nfcig	e2_1_1
rename	w1_h_nfalc	e2_1_2
rename	w1_h_nfent	e2_1_3
rename	w1_h_nfspr	e2_1_4
rename	w1_h_nfper	e2_1_5
rename	w1_h_nfjew	e2_1_6
rename	w1_h_nfpap	e2_1_7
rename	w1_h_nfcel	e2_1_8
rename	w1_h_nftel	e2_1_9
rename	w1_h_nflot	e2_1_10
rename	w1_h_nfnet	e2_1_11
rename	w1_h_nftrp	e2_1_12
rename	w1_h_nfcer	e2_1_13
rename	w1_h_nfcar	e2_1_14
rename	w1_h_nfpetr	e2_1_15
rename	w1_h_nftran	e2_1_16
rename	w1_h_nfwat	e2_1_17
rename	w1_h_nfele	e2_1_18
rename	w1_h_nfene	e2_1_19
rename	w1_h_nfmun	e2_1_20
rename	w1_h_nflev	e2_1_21
rename	w1_h_nfinsl	e2_1_22
rename	w1_h_nfinsf	e2_1_23
rename	w1_h_nfinsedu	e2_1_24
rename	w1_h_nfinssh	e2_1_25
rename	w1_h_nfkit	e2_1_26
rename	w1_h_nfdwl	e2_1_27
rename	w1_h_nfbed	e2_1_28
rename	w1_h_nfmat	e2_1_29
rename	w1_h_nfhp	e2_1_30
rename	w1_h_nffrn	e2_1_31
rename	w1_h_nfclth	e2_1_32
rename	w1_h_nfcltha	e2_1_33
rename	w1_h_nfclthm	e2_1_34
rename	w1_h_nfmedaid	e2_1_35
rename	w1_h_nfdoc	e2_1_36
rename	w1_h_nfhsp	e2_1_37
rename	w1_h_nfmed	e2_1_38
rename	w1_h_nftrad	e2_1_39
rename	w1_h_nfhom	e2_1_40
rename	w1_h_nfschfee	e2_1_41
rename	w1_h_nfschstat	e2_1_42
rename	w1_h_nfschuni	e2_1_43
rename	w1_h_nfscho	e2_1_44
rename	w1_h_nfwsh	e2_1_45
rename	w1_h_nfchld	e2_1_46
rename	w1_h_nfrel	e2_1_47
rename	w1_h_nfdom	e2_1_48
rename	w1_h_nfswim	e2_1_49
rename	w1_h_nfpets	e2_1_50
rename	w1_h_nftoys	e2_1_51
rename	w1_h_nfgfts	e2_1_52
rename	w1_h_nfinctax	e2_1_53
		
rename	w1_h_nfcigspn	e2_2_1
rename	w1_h_nfalcspn	e2_2_2
rename	w1_h_nfentspn	e2_2_3
rename	w1_h_nfsprspn	e2_2_4
rename	w1_h_nfperspn	e2_2_5
rename	w1_h_nfjewspn	e2_2_6
rename	w1_h_nfpapspn	e2_2_7
rename	w1_h_nfcelspn	e2_2_8
rename	w1_h_nftelspn	e2_2_9
rename	w1_h_nflotspn	e2_2_10
rename	w1_h_nfnetspn	e2_2_11
rename	w1_h_nftrpspn	e2_2_12
rename	w1_h_nfcerspn	e2_2_13
rename	w1_h_nfcarspn	e2_2_14
rename	w1_h_nfpetrspn	e2_2_15
rename	w1_h_nftranspn	e2_2_16
rename	w1_h_nfwatspn	e2_2_17
rename	w1_h_nfelespn	e2_2_18
rename	w1_h_nfenespn	e2_2_19
rename	w1_h_nfmunspn	e2_2_20
rename	w1_h_nflevspn	e2_2_21
rename	w1_h_nfinslspn	e2_2_22
rename	w1_h_nfinsfspn	e2_2_23
rename	w1_h_nfinseduspn	e2_2_24
rename	w1_h_nfinsshspn	e2_2_25
rename	w1_h_nfkitspn	e2_2_26
rename	w1_h_nfdwlspn	e2_2_27
rename	w1_h_nfbedspn	e2_2_28
rename	w1_h_nfmatspn	e2_2_29
rename	w1_h_nfhpspn	e2_2_30
rename	w1_h_nffrnspn	e2_2_31
rename	w1_h_nfclthspn	e2_2_32
rename	w1_h_nfclthaspn	e2_2_33
rename	w1_h_nfclthmspn	e2_2_34
rename	w1_h_nfmedaidspn	e2_2_35
rename	w1_h_nfdocspn	e2_2_36
rename	w1_h_nfhspspn	e2_2_37
rename	w1_h_nfmedspn	e2_2_38
rename	w1_h_nftradspn	e2_2_39
rename	w1_h_nfhomspn	e2_2_40
rename	w1_h_nfschfeespn	e2_2_41
rename	w1_h_nfschstatspn	e2_2_42
rename	w1_h_nfschunispn	e2_2_43
rename	w1_h_nfschospn	e2_2_44
rename	w1_h_nfwshspn	e2_2_45
rename	w1_h_nfchldspn	e2_2_46
rename	w1_h_nfrelspn	e2_2_47
rename	w1_h_nfdomspn	e2_2_48
rename	w1_h_nfswimspn	e2_2_49
rename	w1_h_nfpetsspn	e2_2_50
rename	w1_h_nftoysspn	e2_2_51
rename	w1_h_nfgftsspn	e2_2_52
rename	w1_h_nfinctaxspn	e2_2_53

*--------------------------------------------------------------------------------------------
*Renaming variables related to durable goods ownership
		
rename	w1_h_ownrad	f1_1
rename	w1_h_ownhif	f1_2
rename	w1_h_owntel	f1_3
rename	w1_h_ownsat	f1_4
rename	w1_h_ownvid	f1_5
rename	w1_h_owncom	f1_6
rename	w1_h_owncam	f1_7
rename	w1_h_owncel	f1_8
rename	w1_h_ownelestv	f1_9
rename	w1_h_owngasstv	f1_10
rename	w1_h_ownparstv	f1_11
rename	w1_h_ownmic	f1_12
rename	w1_h_ownfrg	f1_13
rename	w1_h_ownwsh	f1_14
rename	w1_h_ownsew	f1_15
rename	w1_h_ownlng	f1_16
rename	w1_h_ownvehpri	f1_17
rename	w1_h_ownvehcom	f1_18
rename	w1_h_ownmot	f1_19
rename	w1_h_ownbic	f1_20
rename	w1_h_ownboat	f1_21
rename	w1_h_ownboatmot	f1_22
rename	w1_h_owncrt	f1_23
rename	w1_h_ownplg	f1_24
rename	w1_h_owntra	f1_25
rename	w1_h_ownwhl	f1_26
rename	w1_h_ownmll	f1_27

*-------------------------------------------------------------------------------------------------
*Renaming variables related to negative shocks
		
rename	w1_h_negdthf	g1_1_1
rename	w1_h_negdthfmn	g1_2m_1
rename	w1_h_negdthfyr	g1_2y_1
rename	w1_h_negdthfinc	g1_3_1
		
rename	w1_h_negdthfr	g1_1_2
rename	w1_h_negdthfrmn	g1_2m_2
rename	w1_h_negdthfryr	g1_2y_2
rename	w1_h_negdthfrin	g1_3_2
		
rename	w1_h_negdtho	g1_1_3
rename	w1_h_negdthomn	g1_2m_3
rename	w1_h_negdthoyr	g1_2y_3
rename	w1_h_negdthocst	g1_4_3
		
rename	w1_h_negill	g1_1_4
rename	w1_h_negillmn	g1_2m_4
rename	w1_h_negillyr	g1_2y_4
rename	w1_h_negillcst	g1_4_4
		
rename	w1_h_negstc	g1_1_5
rename	w1_h_negstcmn	g1_2m_5
rename	w1_h_negstcyr	g1_2y_5
rename	w1_h_negstccst	g1_4_5
		
rename	w1_h_negcrp	g1_1_6
rename	w1_h_negcrpmn	g1_2m_6
rename	w1_h_negcrpyr	g1_2y_6
rename	w1_h_negcrpcst	g1_4_6
		
rename	w1_h_negwrk	g1_1_7
rename	w1_h_negwrkmn	g1_2m_7
rename	w1_h_negwrkyr	g1_2y_7
rename	w1_h_negwrkinc	g1_3_7
		
rename	w1_h_negjob	g1_1_8
rename	w1_h_negjobmn	g1_2m_8
rename	w1_h_negjobyr	g1_2y_8
rename	w1_h_negjobinc	g1_3_8
		
rename	w1_h_negrem	g1_1_9
rename	w1_h_negremmn	g1_2m_9
rename	w1_h_negremyr	g1_2y_9
rename	w1_h_negreminc	g1_3_9
		
rename	w1_h_neggrn	g1_1_10
rename	w1_h_neggrnmn	g1_2m_10
rename	w1_h_neggrnyr	g1_2y_10
rename	w1_h_neggrninc	g1_3_10
		
rename	w1_h_negpro	g1_1_11
rename	w1_h_negpromn	g1_2m_11
rename	w1_h_negproyr	g1_2y_11
rename	w1_h_negprocst	g1_4_11
		
rename	w1_h_nego	g1_1_12
rename	w1_h_negomn	g1_2m_12
rename	w1_h_negoyr	g1_2y_12
rename	w1_h_negoinc	g1_3_12
rename	w1_h_negocst	g1_4_12
cap rename	w1_h_ogds	g1_4_12_o

*---------------------------------------------------------------------------------------------------
*Renaming variables related to positive shocks
		
rename	w1_h_posjob	g2_1_1
rename	w1_h_posjobmn	g2_2m_1
rename	w1_h_posjobyr	g2_2y_1
rename	w1_h_posjobinc	g2_3_1
		
rename	w1_h_posrem	g2_1_2
rename	w1_h_posremmn	g2_2m_2
rename	w1_h_posremyr	g2_2y_2
rename	w1_h_posreminc	g2_3_2
		
rename	w1_h_posgrn	g2_1_3
rename	w1_h_posgrnmn	g2_2m_3
rename	w1_h_posgrnyr	g2_2y_3
rename	w1_h_posgrninc	g2_3_3
		
rename	w1_h_posinh	g2_1_4
rename	w1_h_posinhmn	g2_2m_4
rename	w1_h_posinhyr	g2_2y_4
		
rename	w1_h_posinhv	g2_4_4
		
rename	w1_h_posfrm	g2_1_5
rename	w1_h_posfrmmn	g2_2m_5
rename	w1_h_posfrmyr	g2_2y_5
		
rename	w1_h_posfrmv	g2_4_5
		
rename	w1_h_possch	g2_1_6
rename	w1_h_posschmn	g2_2m_6
rename	w1_h_posschyr	g2_2y_6
		
rename	w1_h_posschv	g2_4_6
		
rename	w1_h_poso1	g2_1_7
rename	w1_h_poso1mn	g2_2m_7
rename	w1_h_poso1yr	g2_2y_7
rename	w1_h_poso1inc	g2_3_7
rename	w1_h_poso1v	g2_4_7
		
rename	w1_h_poso2	g2_1_8
rename	w1_h_poso2mn	g2_2m_8
rename	w1_h_poso2yr	g2_2y_8
rename	w1_h_poso2inc	g2_3_8
rename	w1_h_poso2v	g2_4_8

*--------------------------------------------------------------------------------------------------------------
*Renaming agricultural variables

rename	w1_h_ag	h1
rename	w1_h_agcom	h2
rename	w1_h_aglndcom	h3_1
rename	w1_h_aglndemp	h3_2
rename	w1_h_aglndref	h3_3
rename	w1_h_aglndequ	h3_4
rename	w1_h_aglndcomm	h3_5
rename	w1_h_aglndres	h3_6
		
rename	w1_h_agcr	h4_1
		
rename	w1_h_agcrml	h4_2_1
rename	w1_h_agcrsor	h4_2_2
rename	w1_h_agcrwht	h4_2_3
rename	w1_h_agcrmil	h4_2_4
rename	w1_h_agcrpas	h4_2_5
rename	w1_h_agcrcot	h4_2_6
rename	w1_h_agcrsug	h4_2_7
rename	w1_h_agcrtea	h4_2_8
rename	w1_h_agcrtim	h4_2_9
rename	w1_h_agcrgrn	h4_2_10
rename	w1_h_agcrdec	h4_2_11
rename	w1_h_agcrcit	h4_2_12
rename	w1_h_agcrsub	h4_2_13
rename	w1_h_agcrfo	h4_2_14
rename	w1_h_agcrtom	h4_2_15
rename	w1_h_agcrspi	h4_2_16
rename	w1_h_agcrws	h4_2_17
rename	w1_h_agcrcab	h4_2_18
rename	w1_h_agcrpot	h4_2_19
rename	w1_h_agcrpmp	h4_2_20
rename	w1_h_agcrcar	h4_2_21
rename	w1_h_agcrmad	h4_2_22
rename	w1_h_agcroni	h4_2_23
rename	w1_h_agcrgb	h4_2_24
rename	w1_h_agcrdb	h4_2_25
rename	w1_h_agcrlet	h4_2_26
rename	w1_h_agcrveg	h4_2_27

rename	w1_h_agcrmlu	h4_3_1
rename	w1_h_agcrsoru	h4_3_2
rename	w1_h_agcrwhtu	h4_3_3
rename	w1_h_agcrmilu	h4_3_4
rename	w1_h_agcrpasu	h4_3_5
rename	w1_h_agcrcotu	h4_3_6
rename	w1_h_agcrsugu	h4_3_7
rename	w1_h_agcrteau	h4_3_8
rename	w1_h_agcrtimu	h4_3_9
rename	w1_h_agcrgrnu	h4_3_10
rename	w1_h_agcrdecu	h4_3_11
rename	w1_h_agcrcitu	h4_3_12
rename	w1_h_agcrsubu	h4_3_13
rename	w1_h_agcrfou	h4_3_14
rename	w1_h_agcrtomu	h4_3_15
rename	w1_h_agcrspiu	h4_3_16
rename	w1_h_agcrwsu	h4_3_17
rename	w1_h_agcrcabu	h4_3_18
rename	w1_h_agcrpotu	h4_3_19
rename	w1_h_agcrpmpu	h4_3_20
rename	w1_h_agcrcaru	h4_3_21
rename	w1_h_agcrmadu	h4_3_22
rename	w1_h_agcroniu	h4_3_23
rename	w1_h_agcrgbu	h4_3_24
rename	w1_h_agcrdbu	h4_3_25
rename	w1_h_agcrletu	h4_3_26
rename	w1_h_agcrvegu	h4_3_27
		
rename	w1_h_agcrmlhar	h4_4_1
rename	w1_h_agcrsorhar	h4_4_2
rename	w1_h_agcrwhthar	h4_4_3
rename	w1_h_agcrmilhar	h4_4_4
rename	w1_h_agcrpashar	h4_4_5
rename	w1_h_agcrcothar	h4_4_6
rename	w1_h_agcrsughar	h4_4_7
rename	w1_h_agcrteahar	h4_4_8
rename	w1_h_agcrtimhar	h4_4_9
rename	w1_h_agcrgrnhar	h4_4_10
rename	w1_h_agcrdechar	h4_4_11
rename	w1_h_agcrcithar	h4_4_12
rename	w1_h_agcrsubhar	h4_4_13
rename	w1_h_agcrfohar	h4_4_14
rename	w1_h_agcrtomhar	h4_4_15
rename	w1_h_agcrspihar	h4_4_16
rename	w1_h_agcrwshar	h4_4_17
rename	w1_h_agcrcabhar	h4_4_18
rename	w1_h_agcrpothar	h4_4_19
rename	w1_h_agcrpmphar	h4_4_20
rename	w1_h_agcrcarhar	h4_4_21
rename	w1_h_agcrmadhar	h4_4_22
rename	w1_h_agcronihar	h4_4_23
rename	w1_h_agcrgbhar	h4_4_24
rename	w1_h_agcrdbhar	h4_4_25
rename	w1_h_agcrlethar	h4_4_26
rename	w1_h_agcrveghar	h4_4_27
		
rename	w1_h_agcrmlsll	h4_5_1
rename	w1_h_agcrsorsll	h4_5_2
rename	w1_h_agcrwhtsll	h4_5_3
rename	w1_h_agcrmilsll	h4_5_4
rename	w1_h_agcrpassll	h4_5_5
rename	w1_h_agcrcotsll	h4_5_6
rename	w1_h_agcrsugsll	h4_5_7
rename	w1_h_agcrteasll	h4_5_8
rename	w1_h_agcrtimsll	h4_5_9
rename	w1_h_agcrgrnsll	h4_5_10
rename	w1_h_agcrdecsll	h4_5_11
rename	w1_h_agcrcitsll	h4_5_12
rename	w1_h_agcrsubsll	h4_5_13
rename	w1_h_agcrfosll	h4_5_14
rename	w1_h_agcrtomsll	h4_5_15
rename	w1_h_agcrspisll	h4_5_16
rename	w1_h_agcrwssll	h4_5_17
rename	w1_h_agcrcabsll	h4_5_18
rename	w1_h_agcrpotsll	h4_5_19
rename	w1_h_agcrpmpsll	h4_5_20
rename	w1_h_agcrcarsll	h4_5_21
rename	w1_h_agcrmadsll	h4_5_22
rename	w1_h_agcronisll	h4_5_23
rename	w1_h_agcrgbsll	h4_5_24
rename	w1_h_agcrdbsll	h4_5_25
rename	w1_h_agcrletsll	h4_5_26
rename	w1_h_agcrvegsll	h4_5_27
		
rename	w1_h_agcrmlval	h4_6_1
rename	w1_h_agcrsorval	h4_6_2
rename	w1_h_agcrwhtval	h4_6_3
rename	w1_h_agcrmilval	h4_6_4
rename	w1_h_agcrpasval	h4_6_5
rename	w1_h_agcrcotval	h4_6_6
rename	w1_h_agcrsugval	h4_6_7
rename	w1_h_agcrteaval	h4_6_8
rename	w1_h_agcrtimval	h4_6_9
rename	w1_h_agcrgrnval	h4_6_10
rename	w1_h_agcrdecval	h4_6_11
rename	w1_h_agcrcitval	h4_6_12
rename	w1_h_agcrsubval	h4_6_13
rename	w1_h_agcrfoval	h4_6_14
rename	w1_h_agcrtomval	h4_6_15
rename	w1_h_agcrspival	h4_6_16
rename	w1_h_agcrwsval	h4_6_17
rename	w1_h_agcrcabval	h4_6_18
rename	w1_h_agcrpotval	h4_6_19
rename	w1_h_agcrpmpval	h4_6_20
rename	w1_h_agcrcarval	h4_6_21
rename	w1_h_agcrmadval	h4_6_22
rename	w1_h_agcronival	h4_6_23
rename	w1_h_agcrgbval	h4_6_24
rename	w1_h_agcrdbval	h4_6_25
rename	w1_h_agcrletval	h4_6_26
rename	w1_h_agcrvegval	h4_6_27
		
rename	w1_h_agcrmlgv	h4_7_1
rename	w1_h_agcrsorgv	h4_7_2
rename	w1_h_agcrwhtgv	h4_7_3
rename	w1_h_agcrmilgv	h4_7_4
rename	w1_h_agcrpasgv	h4_7_5
rename	w1_h_agcrcotgv	h4_7_6
rename	w1_h_agcrsuggv	h4_7_7
rename	w1_h_agcrteagv	h4_7_8
rename	w1_h_agcrtimgv	h4_7_9
rename	w1_h_agcrgrngv	h4_7_10
rename	w1_h_agcrdecgv	h4_7_11
rename	w1_h_agcrcitgv	h4_7_12
rename	w1_h_agcrsubgv	h4_7_13
rename	w1_h_agcrfogv	h4_7_14
rename	w1_h_agcrtomgv	h4_7_15
rename	w1_h_agcrspigv	h4_7_16
rename	w1_h_agcrwsgv	h4_7_17
rename	w1_h_agcrcabgv	h4_7_18
rename	w1_h_agcrpotgv	h4_7_19
rename	w1_h_agcrpmpgv	h4_7_20
rename	w1_h_agcrcargv	h4_7_21
rename	w1_h_agcrmadgv	h4_7_22
rename	w1_h_agcronigv	h4_7_23
rename	w1_h_agcrgbgv	h4_7_24
rename	w1_h_agcrdbgv	h4_7_25
rename	w1_h_agcrletgv	h4_7_26
rename	w1_h_agcrveggv	h4_7_27
		
rename	w1_h_agcrmlcon	h4_8_1
rename	w1_h_agcrsorcon	h4_8_2
rename	w1_h_agcrwhtcon	h4_8_3
rename	w1_h_agcrmilcon	h4_8_4
rename	w1_h_agcrpascon	h4_8_5
rename	w1_h_agcrcotcon	h4_8_6
rename	w1_h_agcrsugcon	h4_8_7
rename	w1_h_agcrteacon	h4_8_8
rename	w1_h_agcrtimcon	h4_8_9
rename	w1_h_agcrgrncon	h4_8_10
rename	w1_h_agcrdeccon	h4_8_11
rename	w1_h_agcrcitcon	h4_8_12
rename	w1_h_agcrsubcon	h4_8_13
rename	w1_h_agcrfocon	h4_8_14
rename	w1_h_agcrtomcon	h4_8_15
rename	w1_h_agcrspicon	h4_8_16
rename	w1_h_agcrwscon	h4_8_17
rename	w1_h_agcrcabcon	h4_8_18
rename	w1_h_agcrpotcon	h4_8_19
rename	w1_h_agcrpmpcon	h4_8_20
rename	w1_h_agcrcarcon	h4_8_21
rename	w1_h_agcrmadcon	h4_8_22
rename	w1_h_agcronicon	h4_8_23
rename	w1_h_agcrgbcon	h4_8_24
rename	w1_h_agcrdbcon	h4_8_25
rename	w1_h_agcrletcon	h4_8_26
rename	w1_h_agcrvegcon	h4_8_27
		
rename	w1_h_agls	h5_1
		
rename	w1_h_aglscat	h5_2_1
rename	w1_h_aglsshp	h5_2_2
rename	w1_h_aglsgt	h5_2_3

rename	w1_h_aglspig	h5_2_4
rename	w1_h_aglshrs	h5_2_5
rename	w1_h_aglsdnk	h5_2_6
rename	w1_h_aglschc	h5_2_7
rename	w1_h_aglsdck	h5_2_8
rename	w1_h_aglsost	h5_2_9

rename 	w1_h_aglspigown	h5_3_4 
rename 	w1_h_aglshrsown 	h5_3_5 
rename 	w1_h_aglsdnkown	h5_3_6 
rename 	w1_h_aglschcown	h5_3_7 
rename 	w1_h_aglsdckown	h5_3_8 
rename 	w1_h_aglsostown	h5_3_9 

rename	w1_h_aglscatown	h5_3_1
rename 	w1_h_aglsshpown 	h5_3_2 
rename 	w1_h_aglsgtown	h5_3_3 		
		
rename	w1_h_aglscatsll	h5_4_1
rename	w1_h_aglsshpsll	h5_4_2
rename	w1_h_aglsgtsll	h5_4_3
rename	w1_h_aglspigsll	h5_4_4
rename	w1_h_aglshrssll	h5_4_5
rename	w1_h_aglsdnksll	h5_4_6
rename	w1_h_aglschcsll	h5_4_7
rename	w1_h_aglsdcksll	h5_4_8
rename	w1_h_aglsostsll	h5_4_9

rename	w1_h_aglscatval	h5_5_1
rename	w1_h_aglsshpval	h5_5_2
rename	w1_h_aglsgtval	h5_5_3
rename	w1_h_aglspigval	h5_5_4
rename	w1_h_aglshrsval	h5_5_5
rename	w1_h_aglsdnkval	h5_5_6
rename	w1_h_aglschcval	h5_5_7
rename	w1_h_aglsdckval	h5_5_8
rename	w1_h_aglsostval	h5_5_9
		
rename	w1_h_aglscatgv	h5_6_1
rename	w1_h_aglsshpgv	h5_6_2
rename	w1_h_aglsgtgv	h5_6_3
rename	w1_h_aglspiggv	h5_6_4
rename	w1_h_aglshrsgv	h5_6_5
rename	w1_h_aglsdnkgv	h5_6_6
rename	w1_h_aglschcgv	h5_6_7
rename	w1_h_aglsdckgv	h5_6_8
rename	w1_h_aglsostgv	h5_6_9

rename	w1_h_aglscatlss	h5_7_1
rename	w1_h_aglsshplss	h5_7_2
rename	w1_h_aglsgtlss	h5_7_3
rename	w1_h_aglspiglss	h5_7_4
rename	w1_h_aglshrslss	h5_7_5
rename	w1_h_aglsdnklss	h5_7_6
rename	w1_h_aglschclss	h5_7_7
rename	w1_h_aglsdcklss	h5_7_8
rename	w1_h_aglsostlss	h5_7_9

rename	w1_h_aglscatcon	h5_8_1
rename	w1_h_aglsshpcon	h5_8_2
rename	w1_h_aglsgtcon	h5_8_3
rename	w1_h_aglspigcon	h5_8_4
rename	w1_h_aglshrscon	h5_8_5
rename	w1_h_aglsdnkcon	h5_8_6
rename	w1_h_aglschccon	h5_8_7
rename	w1_h_aglsdckcon	h5_8_8
rename	w1_h_aglsostcon	h5_8_9

rename	w1_h_ageggu	h6_1_1
rename	w1_h_ageggnum	h6_1_2
rename	w1_h_ageggsll	h6_1_3
rename	w1_h_ageggrev	h6_1_4
rename	w1_h_agegggv	h6_1_5
rename	w1_h_ageggcon	h6_1_6
		
rename	w1_h_agdrmlkm	h6_2_1_1
rename	w1_h_agdrbutm	h6_2_1_2
rename	w1_h_agdrom	h6_2_1_3
		
rename	w1_h_agdrmlku	h6_2_2_1
rename	w1_h_agdrbutu	h6_2_2_2
rename	w1_h_agdrou	h6_2_2_3
		
rename	w1_h_agdrmlkprd	h6_2_3_1
rename	w1_h_agdrbutprd	h6_2_3_2
rename	w1_h_agdroprd	h6_2_3_3
		
rename	w1_h_agdrmlksll	h6_2_4_1
rename	w1_h_agdrbutsll	h6_2_4_2
rename	w1_h_agdrosll	h6_2_4_3
		
rename	w1_h_agdrmlkval	h6_2_5_1
rename	w1_h_agdrbutval	h6_2_5_2
rename	w1_h_agdroval	h6_2_5_3
		
rename	w1_h_agdrmlkgv	h6_2_6_1
rename	w1_h_agdrbutgv	h6_2_6_2
rename	w1_h_agdrogv	h6_2_6_3
		
rename	w1_h_agdrmlkcon	h6_2_7_1
rename	w1_h_agdrbutcon	h6_2_7_2
rename	w1_h_agdrocon	h6_2_7_3
		
rename	w1_h_agwlm	h6_3_1_1
rename	w1_h_agmhm	h6_3_1_2
rename	w1_h_agwlu	h6_3_2_1
rename	w1_h_agmhu	h6_3_2_2
		
rename	w1_h_agwlnum	h6_3_3_1
rename	w1_h_agmhnum	h6_3_3_2
rename	w1_h_agwlsll	h6_3_4_1
rename	w1_h_agmhsll	h6_3_4_2
rename	w1_h_agwlval	h6_3_5_1
rename	w1_h_agmhval	h6_3_5_2
rename	w1_h_agwlgv	h6_3_6_1
rename	w1_h_agmhgv	h6_3_6_2
rename	w1_h_agwlcon	h6_3_7_1
rename	w1_h_agmhcon	h6_3_7_2
		
rename	w1_h_agilab	h7_1_1
rename	w1_h_agifrt	h7_1_2
rename	w1_h_agiman	h7_1_3
rename	w1_h_agichm	h7_1_4
rename	w1_h_agiplgh	h7_1_5
rename	w1_h_agiseed	h7_1_6
rename	w1_h_agidip	h7_1_7
rename	w1_h_agivet	h7_1_8
rename	w1_h_agifeed	h7_1_9
rename	w1_h_agiinv	h7_1_10
rename	w1_h_agirep	h7_1_11
		
rename	w1_h_agilabspn	h7_2_1
rename	w1_h_agifrtspn	h7_2_2
rename	w1_h_agimanspn	h7_2_3
rename	w1_h_agichmspn	h7_2_4
rename	w1_h_agiplghspn	h7_2_5
rename	w1_h_agiseedspn	h7_2_6
rename	w1_h_agidipspn	h7_2_7
rename	w1_h_agivetspn	h7_2_8
rename	w1_h_agifeedspn	h7_2_9
rename	w1_h_agiinvspn	h7_2_10
rename	w1_h_agirepspn	h7_2_11

*********************************************************************************************************************************
*Renaming household descriptor variables
rename w1_hhsizer hhsizer 
rename w1_hhincome hhincome 
rename w1_prov2011 province
rename w1_geo2011 geo 
rename w1_cluster a1

*-------------------------------------------------------------------------------------------------------------------------------------

gen a3 = w1_hhid
gen hhincome_pc=hhincome/hhsizer				//Creating a household percapita income variable

**********************************************************************
*	Preparation
**********************************************************************
recode  d8 d9 d11 d12 d13 (-999/-1=.)
gen lgincome_pc=log(hhincome_pc)
gen lgd13 =log(d13)

gen lgd9 =log(d9)
gen lgd8 =log(d8)
gen lgd11=log(d11)
gen lgd12=log(d12)

recode d1 (-999/-1=.)
recode d3_* (-999/-1=.)
recode d2 (-999/-1=.)
recode d4 (-999/-1=.)
recode d34 (-999/-1=.)
recode d31 (-999/-1=.)	
recode d38 (-999/-1=.)	
recode d13 (-999/-1=.)	

tab d1,gen(dwell)
rename dwell1 house
rename dwell8 shack
rename dwell2 trad

tab d3_1,gen(roof)
rename roof3 corru
rename roof9 tile
rename roof10 asb

tab d3_2,gen(wall)
rename wall1 brick
gen mud=wall7==1|wall10==1

**********************************************************************
*	Imputing for renters
**********************************************************************

gen rent_paid=0
replace rent_paid=1 if d10==1
lab def rent_paid 0 "No" 1 "Yes", add
lab val rent_paid rent_paid

gen rent_exp=d11 if rent_paid==1
replace rent_exp=. if rent_exp==0
gen ln_rent_exp=ln(rent_exp)

gen African2=African
gen Coloured2=Coloured
gen Asian2=Asian
gen White2=White
replace African2=0 if African2==.
replace Coloured2=0 if Coloured2==.
replace Asian2=0 if Asian2==.
replace White2=0 if White2==.

gen income_d=lgincome_pc==.
replace lgincome_pc=0 if income_d==1

xi: impute ln_rent_exp lgincome income_d homerooms_d i.hometype_d homerooms homeroomssq i.homeroof_d i.homewalls_d Coloured2 Asian2 White2 rural tribal maxed i.province if rent_paid==1, gen(ln_rent_exp_hat)

gen rentexpend=rent_exp
replace rentexpend=exp(ln_rent_exp_hat) if rent_paid==1 & rent_exp==.
gen rentexpend_source=.
replace rentexpend_source=1 if rent_exp!=.
replace rentexpend_source=0 if rent_paid==1 & rent_exp==.
lab def rentexpend_source 0 "Imputed" 1 "Survey", modify
lab val rentexpend_source rentexpend_source
lab var rentexpend_source "Source of data for rentexpend"

tab rentexpend_source, sum(rentexpend)

lab var rentexpend "Amount spent on renting dwelling per month"

drop ln_rent_exp African2 Coloured2 Asian2 White2 rent_paid rent_exp income_d _Ihometype__1 _Ihomeroof__1 _Ihomewalls_1 _Iprovince_2 _Iprovince_3 _Iprovince_4 _Iprovince_5 _Iprovince_6 _Iprovince_7 _Iprovince_8 _Iprovince_9 ln_rent_exp_hat

*********************************************************************************************
*	Adding rentexpend to w1_hhimprent to get a figure for total rental and implied rental *
*********************************************************************************************
/*
gen w1_hhimprent_exp=w1_hhimprent_inc
replace w1_hhimprent_exp=rentexpend if w1_hhimprent_inc==. & rentexpend!=.
sum w1_hhimprent_inc w1_hhimprent_exp, det
lab var  w1_hhimprent_exp "Household rent + implied rent - full imputations"
*/
*******************************************************
*	Final step of summing for total HH expenditure	*
*******************************************************

rename rentexpend w1_h_rentexpend
rename rentexpend_source w1_h_rentexpend_flg

*egen temp=rowtotal( w1_h_expf w1_h_expnf w1_hhimprent_exp), mi
egen temp=rowtotal( w1_expf w1_expnf w1_hhimprent_exp)
replace w1_expenditure=temp
drop temp
sum w1_hhincome w1_expenditure, det //[w=w1_wgt], det
sort w1_hhid


keep w1_hhid w1_expenditure w1_h_rentexpend w1_h_rentexpend_flg w1_hhimprent_exp

ren	w1_h_rentexpend		w1_rentexpend
ren	w1_h_rentexpend_flg	w1_rentexpend_flg

replace w1_rentexpend_flg = 2 if w1_rentexpend_flg ==0
lab def rentexpend_source  1 "Survey" 2 "Imputed", modify
lab val w1_rentexpend_flg rentexpend_source

sort w1_hhid

save "$DataOUT\hhderived_$VersionOUT.dta", replace
erase "$DataOUT\tempdata.dta"
*---------------------------------------------------------------------------------------------------------------------------
